<?php

defined('PF_VERSION') OR exit('Access denied');

/**
 *
 * @package		PageFlex
 * @author		PageFlex Team (phucpm.it@gmail.com)
 * @copyright           PageFlex Team
 * @link		http://page-flex.com
 * @since		Version 1.0
 * @filesource
 *
 */
class Pf_Comment_Controller extends Pf_Plugin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->view->set_path('comment');
        $this->model = new Pf_Comment_Model;
        $this->acl = array(1, 2);
        $this->check_acl();
    }

    public function main()
    {
        $conditions = '1';
        $param = array();
        $url = admin_url('admin-page=comment', false);
        //status
        if ($this->input->has_get('status')) {
            $conditions .= " and comment_status = ? ";
            $status = $this->input->get('status', true) == 1 ? 1 : 0;
            $param[] = $status;
            $url .= "&status={$status}";
        }

        if ($this->input->has_get('kw')) {
            $conditions .= " and comment_content like ? ";
            $param[] = "%{$this->input->get('kw')}%";
            $url .= "&kw={$this->input->get('kw')}";
        }

        /* Count paging */
        $total = $this->model->conditions($conditions)
                ->param($param)
                ->count();
        $page = $this->input->has_get('current') ? (int) $this->input->get('current', true) - 1 : 0;
        $per_page = (int) $page * NUM_PER_PAGE;

        /* Get data */
        $condition_get = " WHERE {$conditions} ORDER BY id DESC LIMIT {$per_page}," . NUM_PER_PAGE;
        $comments = $total > 0 ? $this->model->select('id', 'comment_author', 'comment_status', 'comment_content', 'comment_created_date')
                        ->conditions($condition_get)
                        ->get() : array();

        $pagination = new Pf_Paginator($total, NUM_PER_PAGE, 'current');
        $this->data['comments'] = $comments;
        $this->data['pagination'] = $pagination;
        $this->data['url'] = $url;
        $this->view->render('main', $this->data);
    }

    /*
     * Select Action
     */

    public function bulk_action()
    {
        if (!$this->input->has_post('id')) {
            return false;
        }
        $action = $this->input->post('action');
        $ids = $this->input->post('id');
        $current = (int) $this->input->post('current');
        if ($action == 3) {
            $data = $this->model->select('id', 'comment_parent')->get();
            $this->delete_comments($data, $ids);
        } else {
            $this->update_status(array('comment_status' => $action), $ids, $current);
        }
    }

    private function update_status($data, $ids, $current = '')
    {
        $result = $this->model->conditions(' id in(' . generate_where_in($ids) . ')')
                ->param($ids)
                ->update($data, false);
        $messages = array(
            'success' => __('Status is updated successfully', 'comment'),
            'danger' => __('An error has occurred. Please try again', 'comment')
        );
        $this->alertSave($messages, $result);
        Pf_Plugin_Redirect::to("&act=&status=&current={$current}");
    }

    private function get_all_children($data, $id)
    {
        $comments = array();
        $result = array();
        if (is_array($id)) {
            foreach ($data as $value) {
                get_all_children($value, $result, $id, 'comment_parent');
                $comments[] = $result;
            }
        } else {
            get_all_children($data, $result, $id, 'comment_parent');
            $comments = $result;
        }
        return $comments;
    }

    private function delete_comments($data, $ids)
    {
        $get = array();
        foreach ($ids as $value) {
            $get = array_merge($get, $this->get_all_children($data, $value));
        }
        $all_id = array_merge($get, $ids);
        $result = $this->model->conditions(' id in(' . generate_where_in($all_id) . ')')
                        ->param($all_id)->delete();
        $messages = array(
            'success' => __('Comment is deleted successfully', 'comment'),
            'danger' => __('An error has occurred. Please try again', 'comment')
        );
        $this->alertSave($messages, $result);
        Pf_Plugin_Redirect::to("&act=&status=&current=");
    }

    /*
     * Status
     */

    public function status()
    {
        $curent = $this->input->get('current');
        if ($this->input->has_get('id') && $this->input->has_get('type')) {
            $id = $this->input->get('id');
            $status = $this->input->get('type') == 2 ? 0 : 1;
            if ($this->model->set_rules(array())->conditions(' id = ?')
                            ->param($id)->update(array('comment_status' => $status))) {
                $this->session->flash('success', __('Comment is updated successfully', 'comment'));
            } else {
                $this->session->flash('danger', __('An error has occurred. Please try again', 'comment'));
            }
        }
        Pf_Plugin_Redirect::to('&act&id&type&current=' . $curent);
    }

    //Delete
    public function delete()
    {
        $id = $this->input->get('id');
        $data = $this->model->select('id', 'comment_parent')->get();
        $result = $this->get_all_children($data, $id);
        array_unshift($result, $id);
        if ($this->model->conditions(' id in(' . generate_where_in($result) . ')')
                        ->param($result)->delete()) {
            $this->session->flash('success', __('Comment is deleted successfully'));
            Pf_Plugin_Redirect::to('&act&id&current=');
        }
        $this->session->flash('danger', __('An error has occurred. Please try again'));
        Pf_Plugin_Redirect::to('&act&id&current=');
    }

    //Update
    public function ajax_save()
    {
        if (!is_ajax()) {
            return false;
        }
        if ($this->input->has_post('id')) {
            $id = $this->input->post('id');
            $content = $this->input->post('content');
            $data = array('comment_content' => $content);
            if ($this->model->conditions('id = ?')->param($id)->update($data)) {
                echo e($content);
                return;
            }
        }
        echo false;
        return;
    }

}
